%function [fH,AmpH,PhaH]=Harvard
n=51;
r_ratio=1;
L=0.016*(10^-3)/r_ratio;
R=0.102/r_ratio;
kt=0.0136*r_ratio;
kb=kt;
Jm=33.3*(10^-7)*(r_ratio^3);%;3060*10E-6*(d^3);
bm=0.07;%0.01;
kl=100;
bl=0.3;
Simulation_Time=100;
tt=100;
tf=1000;
sim('bandwidth_energy_simulation_three',Simulation_Time);
Fs=20000;
Ftest=1000;
[fH,AmpH,PhaH]=bode_cal(simout(:,1),simout(:,2),Fs,Ftest);
figure2 = figure;
subplot1 = subplot(2,1,1,'Parent',figure2);
semilogx(fH,AmpH,'Parent',subplot1,'Color',[0 0 0],'LineWidth',2);
xlabel('Frequency(Hz)','FontSize',12);
ylabel('Magnitude(dB)','FontSize',12);
box(subplot1,'on');
set(subplot1,'FontSize',12,'XMinorTick','on','XScale','log');
legend('Torque Control');
subplot2 = subplot(2,1,2,'Parent',figure2);
hold(subplot2,'on');
semilogx(fH,PhaH,'Parent',subplot2,'Color',[0 0 0],'LineWidth',2);
xlabel('Frequency(Hz)','FontSize',12);
ylabel('Phase(Degree)','FontSize',12);
box(subplot2,'on');
set(subplot2,'FontSize',12,'XMinorTick','on','XScale','log');
legend('Torque Control');
